<div align="left" style="display: flex; flex-direction: column; align-items: center;">
    <!-- Image on top -->
    <a href="https://www.bareos.com" style="flex-shrink: 0;">
        <img src="https://github.com/agrigorev99/bareos/blob/update_README/bareos-github-banner.png" width="80%">
    </a>
  <!-- Supported Systems row below -->
    <div style="margin-top: 20px;">
       <a href="https://download.bareos.com"> <img src="https://img.shields.io/badge/Linux-0078D6?logo=linux&logoColor=white" alt="Linux"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Debian-0078D6?logo=debian&logoColor=white" alt="Debian"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Fedora-0078D6?logo=fedora&logoColor=white" alt="Fedora"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Red%20Hat-0078D6?logo=redhat&logoColor=white" alt="Red Hat"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/SUSE-0078D6?logo=suse&logoColor=white" alt="SUSE"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Ubuntu-0078D6?logo=ubuntu&logoColor=white" alt="Ubuntu"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/FreeBSD-0078D6?logo=freebsd&logoColor=white" alt="FreeBSD"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/macOS-0078D6?logo=apple&logoColor=white" alt="macOS"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Windows-0078D6?logo=windows&logoColor=white" alt="Windows"></a>
    </div>
    <!-- Badges below -->
    <div style="display: flex; flex-direction: column; align-items: center; margin-top: 10px;">
        <a href="https://github.com/bareos"><img src="https://img.shields.io/github/stars/bareos/bareos?style=social&color=0078D6" alt="GitHub Stars"></a>
      <a href="https://www.bareos.com/services/"> <img src="https://img.shields.io/badge/Get%20Support-Commercial%20Services-1a1a1a?labelColor=1a1a1a&color=gray&logo=megaphone&logoColor=white" alt="Get Support - Commercial Services"></a>
        <a href="https://github.com/sponsors/bareos"><img src="https://img.shields.io/badge/Sponsor-Donate%20Now-1a1a1a?labelColor=1a1a1a&color=gray&logo=github&logoColor=white" alt="Sponsor Bareos"></a>
    </div>

</div>

<br>

**Bareos** is a reliable, cross-network open-source backup solution for data protection, archiving, and recovery. It supports Linux, Windows, FreeBSD, macOS, and other well-established operating systems. Bareos offers scalable, enterprise-grade features for businesses of all sizes, ensuring secure and efficient data management.

---

### Key Features

- **True Open Source**: Licensed under AGPLv3 with no open-core or restrictions.
- **Cross-Platform**: Supports Linux, Windows, FreeBSD, macOS, and more.
- **Network-Based**: Flexible, network-based backups with multiple clients and storage options.
- **Multiple Backends**: Supports disk, tape, and cloud storage.
- **Python Plugin Interface**: Extendable with custom plugins, including VMware integration.
- **NDMP SAN Backups**: High-speed SAN backups using NDMP with DAR/DDAR support.
- **Always Incremental Backups**: Efficient, incremental backup scheme to save storage.
- **Encryption**: Secure backups with built-in encryption.
- **Scriptable CLI**: Automate with the CLI or use the web-based interface (WebUI).
- **Role-Based ACL**: Secure access control with role-based permissions.

---

### Releases
![Last Release](https://img.shields.io/github/v/release/bareos/bareos?color=0078D6&label=Last%20Release)
![License](https://img.shields.io/badge/License-AGPLv3-0078D6)
[![Subscription Packages](https://img.shields.io/badge/Subscription%20Packages-For%20Subscribers-0078D6)](https://download.bareos.com)
[![Community Package](https://img.shields.io/badge/Community%20Package-Download-0078D6)](https://download.bareos.org)

### Documentation
[![Documentation](https://img.shields.io/badge/Documentation-Read%20Docs-0078D6)](https://docs.bareos.org)
[![Security Policy](https://img.shields.io/badge/Security%20Policy-Policy-0078D6)](https://github.com/bareos/bareos/security/policy)
[![Changelog](https://img.shields.io/badge/Changelog-View%20Updates-0078D6)](https://docs.bareos.org/master/Appendix/ReleaseNotes.html)

### Join Our Community
[![GitHub Discussions](https://img.shields.io/badge/GitHub-Discussions-0078D6?logo=github)](https://github.com/bareos/bareos/discussions)
[![Issue Tracker](https://img.shields.io/badge/Issue%20Tracker-Report%20Issues-0078D6)](https://github.com/bareos/bareos/issues)
[![Pull Requests](https://img.shields.io/github/issues-pr/bareos/bareos?color=0078D6&label=Pull%20Requests)](https://github.com/bareos/bareos/pulls)
[![Pull Requests Closed](https://img.shields.io/github/issues-pr-closed/bareos/bareos?color=0078D6&label=Pull%20Requests%20Closed)](https://github.com/bareos/bareos/pulls?q=is%3Apr+is%3Aclosed)
[![Newsletter Signup](https://img.shields.io/badge/Newsletter-Sign%20Up-0078D6)](https://www.bareos.com/sign-up/)
[![Bareos-users Mailing List](https://img.shields.io/badge/Google-Mailing%20List-0078D6)](https://groups.google.com/forum/#!forum/bareos-users)


### Social Media
[![Bareos Blog](https://img.shields.io/badge/Blog-Read%20Posts-0078D6?logo=rss)](https://www.bareos.com/blog/)
[![YouTube Channel](https://img.shields.io/badge/YouTube-Subscribe-FF0000?logo=youtube)](https://www.youtube.com/@BareosBackup)
[![LinkedIn](https://img.shields.io/badge/LinkedIn-Connect%20with%20Us-0077B5?logo=linkedin)](https://www.linkedin.com/company/bareos-gmbh-co-kg/?viewAsMember=true)
[![Mastodon](https://img.shields.io/badge/Mastodon-Follow%20Us-6364FF?logo=mastodon&logoColor=white)](https://social.cologne/@bareos)
[![X (Twitter)](https://img.shields.io/badge/X%20(Twitter)-Follow%20Us-1DA1F2?logo=twitter)](https://twitter.com/bareos_backup)
[![Facebook](https://img.shields.io/badge/Facebook-Follow%20Us-1877F2?logo=facebook&logoColor=white)](https://www.facebook.com/bareosbackup/)


## Join the Bareos Team

Are you a developer passionate about open-source technology? We’re always open to collaborating with skilled professionals, whether freelance or employed, ideally based in Germany or the EU. Reach out to us at jobs@bareos.com or join the discussion on our [GitHub Discussions page](https://github.com/bareos/bareos/discussions).

---

## Featured Videos

<a href="https://youtu.be/MF2BLiTDwA0?si=kL7Qg4TfVI9mBl13">
    <img src="https://img.youtube.com/vi/MF2BLiTDwA0/0.jpg" width="300">
</a>
<a href="https://youtu.be/f-2dlqfLFRc?si=HComHfXTtb22bmtV">
    <img src="https://img.youtube.com/vi/f-2dlqfLFRc/0.jpg" width="300">
</a>
<a href="https://youtu.be/eHC4z2ZQXQ0?si=G9Q8OrkwOzFzHtXU">
    <img src="https://img.youtube.com/vi/eHC4z2ZQXQ0/0.jpg" width="300">
</a>

---

## What's New

Bareos 24 brings several exciting enhancements across storage, plugins, and platform support. Here’s a quick look at what’s coming:

### Storage Enhancements
- **Dedupable Storage Backend**: Optimized for deduplication, supporting ZFS, VDO, btrfs, and more.
- **New Cloud Storage Backend**: Drop-in replacement backend that is able to read and write in the same format.

### Plugin & Device Management
- **Python Plugin in Separate Process**: Improves stability by isolating each plugin’s interpreter.
- **Just-in-Time Device Reservation**: Boosts tape drive utilization by reserving devices only when needed.

### Platform & Build Improvements
- **Windows Binaries with MSVC Compiler**: Faster binaries with native Windows support.
- **Universal Linux Client for OpenSSL 3 and ARM64**: Expands support to OpenSSL 3 and ARM architectures.
- **AArch64 Binary Packages**: Testing and support for AArch64 packages.

### Network & Performance
- **Improved Network Resilience**: Enhancements to handle unstable network connections.
- **NDMP Support Enhancements**: Bug fixes and improvements for Bareos’s NDMP support.
- **Preparations for Large Backups**: Ready for future support of backups with over 2 billion files.

<a href="https://docs.bareos.org/" target="_blank" rel="noopener noreferrer">See Release Notes & Changelog</a>

