--   BAREOS® - Backup Archiving REcovery Open Sourced
--
--   Copyright (C) 2025 Bareos GmbH & Co. KG
--
--   This program is Free Software; you can redistribute it and/or
--   modify it under the terms of version three of the GNU Affero General Public
--   License as published by the Free Software Foundation and included
--   in the file LICENSE.
--
--   This program is distributed in the hope that it will be useful, but
--   WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--   Affero General Public License for more details.
--
--   You should have received a copy of the GNU Affero General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
--   02110-1301, USA.

USE [master]
GO

CREATE DATABASE [$(myDB)]
 CONTAINMENT = NONE
 ON  PRIMARY
(
    NAME = N'$(myDB)',
    FILENAME = N'$(db_data_dir)\$(myDB).mdf',
    SIZE = 8192KB,
    MAXSIZE = UNLIMITED,
    FILEGROWTH = 65536KB
),
 FILEGROUP [FileGroup1] CONTAINS FILESTREAM DEFAULT
(
    NAME = N'$(myDB)Attachment',
    FILENAME = N'$(db_data_dir)\$(myDB)Attachment',
    MAXSIZE = UNLIMITED
)
 LOG ON
(
    NAME = N'$(myDB)_log',
    FILENAME = N'$(db_data_dir)\$(myDB)_log.ldf',
    SIZE = 73728KB,
    MAXSIZE = 2048GB,
    FILEGROWTH = 65536KB
)
 WITH CATALOG_COLLATION = DATABASE_DEFAULT, LEDGER = OFF
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [$(myDB)].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO

ALTER DATABASE [$(myDB)] SET ANSI_NULL_DEFAULT OFF
GO

ALTER DATABASE [$(myDB)] SET ANSI_NULLS OFF
GO

ALTER DATABASE [$(myDB)] SET ANSI_PADDING OFF
GO

ALTER DATABASE [$(myDB)] SET ANSI_WARNINGS OFF
GO

ALTER DATABASE [$(myDB)] SET ARITHABORT OFF
GO

ALTER DATABASE [$(myDB)] SET AUTO_CLOSE OFF
GO

ALTER DATABASE [$(myDB)] SET AUTO_SHRINK OFF
GO

ALTER DATABASE [$(myDB)] SET AUTO_UPDATE_STATISTICS ON
GO

ALTER DATABASE [$(myDB)] SET CURSOR_CLOSE_ON_COMMIT OFF
GO

ALTER DATABASE [$(myDB)] SET CURSOR_DEFAULT  GLOBAL
GO

ALTER DATABASE [$(myDB)] SET CONCAT_NULL_YIELDS_NULL OFF
GO

ALTER DATABASE [$(myDB)] SET NUMERIC_ROUNDABORT OFF
GO

ALTER DATABASE [$(myDB)] SET QUOTED_IDENTIFIER OFF
GO

ALTER DATABASE [$(myDB)] SET RECURSIVE_TRIGGERS OFF
GO

ALTER DATABASE [$(myDB)] SET DISABLE_BROKER
GO

ALTER DATABASE [$(myDB)] SET AUTO_UPDATE_STATISTICS_ASYNC OFF
GO

ALTER DATABASE [$(myDB)] SET DATE_CORRELATION_OPTIMIZATION OFF
GO

ALTER DATABASE [$(myDB)] SET TRUSTWORTHY OFF
GO

ALTER DATABASE [$(myDB)] SET ALLOW_SNAPSHOT_ISOLATION OFF
GO

ALTER DATABASE [$(myDB)] SET PARAMETERIZATION SIMPLE
GO

ALTER DATABASE [$(myDB)] SET READ_COMMITTED_SNAPSHOT OFF
GO

ALTER DATABASE [$(myDB)] SET HONOR_BROKER_PRIORITY OFF
GO

ALTER DATABASE [$(myDB)] SET RECOVERY FULL
GO

ALTER DATABASE [$(myDB)] SET MULTI_USER
GO

ALTER DATABASE [$(myDB)] SET PAGE_VERIFY CHECKSUM
GO

ALTER DATABASE [$(myDB)] SET DB_CHAINING OFF
GO

ALTER DATABASE [$(myDB)] SET FILESTREAM(
    NON_TRANSACTED_ACCESS = OFF,
    DIRECTORY_NAME = N'Filestream$(myDB)'
)
GO

ALTER DATABASE [$(myDB)] SET TARGET_RECOVERY_TIME = 60 SECONDS
GO

ALTER DATABASE [$(myDB)] SET DELAYED_DURABILITY = DISABLED
GO

ALTER DATABASE [$(myDB)] SET ACCELERATED_DATABASE_RECOVERY = OFF
GO

ALTER DATABASE [$(myDB)] SET QUERY_STORE = ON
GO

ALTER DATABASE [$(myDB)] SET QUERY_STORE (
    OPERATION_MODE = READ_WRITE,
    CLEANUP_POLICY = (STALE_QUERY_THRESHOLD_DAYS = 30),
    DATA_FLUSH_INTERVAL_SECONDS = 900,
    INTERVAL_LENGTH_MINUTES = 60,
    MAX_STORAGE_SIZE_MB = 1000,
    QUERY_CAPTURE_MODE = AUTO,
    SIZE_BASED_CLEANUP_MODE = AUTO,
    MAX_PLANS_PER_QUERY = 200,
    WAIT_STATS_CAPTURE_MODE = ON
)
GO

ALTER DATABASE [$(myDB)] SET READ_WRITE
GO
