<div align="left" style="display: flex; flex-direction: column; align-items: center;">
    <!-- Image on top -->
    <a href="https://www.bareos.com" style="flex-shrink: 0;">
        <img src="bareos-github-banner.png" width="80%">
    </a>
  <!-- Supported Systems row below -->
    <div style="margin-top: 20px;">
       <a href="https://download.bareos.com"> <img src="https://img.shields.io/badge/Linux-0078D6?logo=linux&logoColor=white" alt="Linux"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Debian-0078D6?logo=debian&logoColor=white" alt="Debian"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Fedora-0078D6?logo=fedora&logoColor=white" alt="Fedora"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Red%20Hat-0078D6?logo=redhat&logoColor=white" alt="Red Hat"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/SUSE-0078D6?logo=suse&logoColor=white" alt="SUSE"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Ubuntu-0078D6?logo=ubuntu&logoColor=white" alt="Ubuntu"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/FreeBSD-0078D6?logo=freebsd&logoColor=white" alt="FreeBSD"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/macOS-0078D6?logo=apple&logoColor=white" alt="macOS"></a>
<a href="https://download.bareos.com"><img src="https://img.shields.io/badge/Windows-0078D6?logo=windows&logoColor=white" alt="Windows"></a>
    </div>
    <!-- Badges below -->
    <div style="display: flex; flex-direction: column; align-items: center; margin-top: 10px;">
        <a href="https://github.com/bareos"><img src="https://img.shields.io/github/stars/bareos/bareos?style=social&color=0078D6" alt="GitHub Stars"></a>
      <a href="https://www.bareos.com/services/"> <img src="https://img.shields.io/badge/Get%20Support-Commercial%20Services-1a1a1a?labelColor=1a1a1a&color=gray&logo=megaphone&logoColor=white" alt="Get Support - Commercial Services"></a>
        <a href="https://github.com/sponsors/bareos"><img src="https://img.shields.io/badge/Sponsor-Donate%20Now-1a1a1a?labelColor=1a1a1a&color=gray&logo=github&logoColor=white" alt="Sponsor Bareos"></a>
    </div>

</div>

<br>

[**Bareos**](https://www.bareos.com) is a reliable, cross-network open-source backup solution for data protection, archiving, and recovery. It supports Linux, Windows, FreeBSD, macOS, and other well-established operating systems. Bareos offers scalable, enterprise-grade features for businesses of all sizes, ensuring secure and efficient data management.

---

### Key Features

- **True Open Source**: Licensed under AGPLv3 with no open-core or restrictions.
- **Cross-Platform**: Supports Linux, Windows, FreeBSD, macOS, and more.
- **Scalable Architecture**: Designed for many clients and storage targets across networks.
- **Multiple Backends**: Supports disk, tape, dedupable and cloud/object storage to store backups.
- **Plugins for Modern Workloads**: Built-in and optional plugins for databases, virtualization, Linux and Windows bare-metal recovery and more.
- **Virtualization Backups**: Support for hypervisors such as VMware vSphere, Proxmox, Hyper-V (depending on version/subscription).
- **NDMP SAN Backups**: High-speed SAN backups using NDMP with DAR/DDAR support.
- **Incremental and Full Backups**: Supports full, incremental, differential, always incremental and virtual full workflows (as configured).
- **Encryption**: Secure backups with built-in encryption.
- **Automation-Friendly**: Scriptable via CLI and integrates well into automation pipelines.
- GUI based administration via Bareos WebUI
- CLI based administration via bconsole
- **Role-Based ACL**: Secure access control with role-based permissions.

---

### Releases
![Last Release](https://img.shields.io/github/v/release/bareos/bareos?color=0078D6&label=Last%20Release)
![License](https://img.shields.io/badge/License-AGPLv3-0078D6)
[![Subscription Packages](https://img.shields.io/badge/Subscription%20Packages-For%20Subscribers-0078D6)](https://download.bareos.com)
[![Community Package](https://img.shields.io/badge/Community%20Package-Download-0078D6)](https://download.bareos.org)

### Documentation
[![Documentation](https://img.shields.io/badge/Documentation-Read%20Docs-0078D6)](https://docs.bareos.org)
[![Security Policy](https://img.shields.io/badge/Security%20Policy-Policy-0078D6)](https://github.com/bareos/bareos/security/policy)
[![Changelog](https://img.shields.io/badge/Changelog-View%20Updates-0078D6)](https://docs.bareos.org/master/Appendix/ReleaseNotes.html)

### Join Our Community
[![GitHub Discussions](https://img.shields.io/badge/GitHub-Discussions-0078D6?logo=github)](https://github.com/bareos/bareos/discussions)
[![Issue Tracker](https://img.shields.io/badge/Issue%20Tracker-Report%20Issues-0078D6)](https://github.com/bareos/bareos/issues)
[![Pull Requests](https://img.shields.io/github/issues-pr/bareos/bareos?color=0078D6&label=Pull%20Requests)](https://github.com/bareos/bareos/pulls)
[![Pull Requests Closed](https://img.shields.io/github/issues-pr-closed/bareos/bareos?color=0078D6&label=Pull%20Requests%20Closed)](https://github.com/bareos/bareos/pulls?q=is%3Apr+is%3Aclosed)
[![Newsletter Signup](https://img.shields.io/badge/Newsletter-Sign%20Up-0078D6)](https://www.bareos.com/sign-up/)
[![Bareos-users Mailing List](https://img.shields.io/badge/Google-Mailing%20List-0078D6)](https://groups.google.com/forum/#!forum/bareos-users)


### Social Media
[![Bareos Blog](https://img.shields.io/badge/Blog-Read%20Posts-0078D6?logo=rss)](https://www.bareos.com/blog/)
[![YouTube Channel](https://img.shields.io/badge/YouTube-Subscribe-FF0000?logo=youtube)](https://www.youtube.com/@BareosBackup)
[![LinkedIn](https://img.shields.io/badge/LinkedIn-Connect%20with%20Us-0077B5?logo=linkedin)](https://www.linkedin.com/company/bareos-gmbh-co-kg/?viewAsMember=true)
[![Mastodon](https://img.shields.io/badge/Mastodon-Follow%20Us-6364FF?logo=mastodon&logoColor=white)](https://social.cologne/@bareos)
[![X (Twitter)](https://img.shields.io/badge/X%20(Twitter)-Follow%20Us-1DA1F2?logo=twitter)](https://twitter.com/bareos_backup)
[![Facebook](https://img.shields.io/badge/Facebook-Follow%20Us-1877F2?logo=facebook&logoColor=white)](https://www.facebook.com/bareosbackup/)


## Join the Bareos Team

Are you a developer passionate about open-source technology? We’re always open to collaborating with skilled professionals, whether freelance or employed, ideally based in Germany or the EU. Reach out to us at jobs@bareos.com or join the discussion on our [GitHub Discussions page](https://github.com/bareos/bareos/discussions).

---

## Videos

<p>
  <a href="https://www.youtube.com/playlist?list=PLo4hatlfsTzQkRYkzHmdhyoPx1Q9PXBEL">
    Watch Bareos videos on YouTube
  </a>
</p>

<a href="https://youtu.be/vl9VSF8C0fg">
  <img src="https://img.youtube.com/vi/vl9VSF8C0fg/0.jpg" width="300" alt="Hyper-V Backups with Bareos 25">
</a>

<a href="https://youtu.be/gLajfP_kF1k">
  <img src="https://img.youtube.com/vi/gLajfP_kF1k/0.jpg" width="300" alt="Bareos 25 Proxmox Plugin – Video Overview">
</a>
<a href="https://youtu.be/f-2dlqfLFRc?si=HComHfXTtb22bmtV">
    <img src="https://img.youtube.com/vi/f-2dlqfLFRc/0.jpg" width="300">
</a>


---


## What's New

Bareos 25 brings new plugins and platform improvements - from extended hypervisor support to Windows bare-metal recovery and improved automation.

### Bareos 25 Plugins and Features
- **Hyper-V Plugin**: Adds native support for Microsoft Hyper-V. The plugin can back up and restore virtual machines and uses Resilient Change Tracking (RCT) for very fast incremental backups. Full and incremental backups are supported, and restore recreates the VM and its disks in Hyper-V.
- **Proxmox Plugin**: Agentless backups for Proxmox Virtual Environment guests. After installing the Bareos File Daemon with the plugin on one cluster node, Bareos can back up both virtual machines and container guests. The plugin currently supports full backups. Restore can recreate a guest on the cluster or restore into a local `.vma` dump file for import via the Proxmox GUI.
- **Barri Plugin (Windows Disaster Recovery)**: The new Bareos Recovery Imager (Barri) plugin provides a toolset for creating and restoring Windows disaster recovery images. It can generate a full recovery image of a running Windows system without downtime, via the File Daemon plugin or `barri-cli.exe`. Recovery can be done through a Linux live environment, via Linux/Windows CLI tools, or inside a Windows PE environment when drivers are required. Supports connected and fully offline workflows.
- **Libcloud Plugin**: Re-adds support for backing up cloud objects stored via the S3 protocol through the Apache Libcloud plugin. The plugin can recurse nested buckets and back up objects. Updated for current Python versions and uses the standard `threading` module. Restores write objects to a local filesystem (not directly back to S3).
- **Qumulo Plugin (Third-party, by Yuzuy)**: Integrates Qumulo clusters with the Bareos File Daemon. Supports full and incremental backups, snapshot-based backups, ACL handling, exclusions, fast scan for changed data (avoids expensive tree walks), and virtual full backups.
- **New Regular Expression Library**: Switches from the legacy regex library to the faster PCRE2 engine on Windows. Depending on the pattern and complexity, expected speedup is between 2× and 20×.
- **Automatic Configuration of Disk Autochanger**: For disk devices configured with `Count > 1`, Bareos now creates required virtual devices automatically and groups them into an autochanger, avoiding manual setup. The remaining manual step is setting an appropriate `Maximum Concurrent Jobs` value in the Director.

<a href="https://docs.bareos.org/master/Appendix/ReleaseNotes.html" target="_blank" rel="noopener noreferrer">See Release Notes & Changelog</a>
