/*
 * Copyright (C) 2020-2021 Bareos GmbH & Co. KG
 * Copyright (C) 2010 SCALITY SA. All rights reserved.
 * http://www.scality.com
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SCALITY SA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL SCALITY SA OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation
 * are those of the authors and should not be interpreted as representing
 * official policies, either expressed or implied, of SCALITY SA.
 *
 * https://github.com/scality/Droplet
 */
#ifndef BAREOS_DROPLET_LIBDROPLET_INCLUDE_DROPLET_ID_SCHEME_H_
#define BAREOS_DROPLET_LIBDROPLET_INCLUDE_DROPLET_ID_SCHEME_H_

/* general */
typedef dpl_status_t (*dpl_gen_random_key_t)(dpl_ctx_t* ctx,
                                             dpl_storage_class_t storage_class,
                                             char* custom,
                                             char* id_buf,
                                             int max_len);

typedef struct dpl_id_scheme_s {
  const char* name; /*!< name of the id_scheme */
  dpl_gen_random_key_t gen_random_key;
} dpl_id_scheme_t;

#define DPL_ID_SCHEME_ANY ((dpl_id_scheme_t*)0x1)

dpl_status_t dpl_gen_random_key(dpl_ctx_t* ctx,
                                dpl_storage_class_t storage_class,
                                char* custom,
                                char* id_buf,
                                int max_len);

#endif  // BAREOS_DROPLET_LIBDROPLET_INCLUDE_DROPLET_ID_SCHEME_H_
