/*
   BAREOS® - Backup Archiving REcovery Open Sourced

   Copyright (C) 2025-2025 Bareos GmbH & Co. KG

   This program is Free Software; you can redistribute it and/or
   modify it under the terms of version three of the GNU Affero General Public
   License as published by the Free Software Foundation and included
   in the file LICENSE.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Affero General Public License for more details.

   You should have received a copy of the GNU Affero General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.
*/

#include "version.h"

#define AS_STR_IMPL(x) #x
#define AS_STR(x) AS_STR_IMPL(x)

#if !defined(BARRI_VERSION)
#  warning "no barri version defined"
#  define BARRI_VERSION "unknown"
#endif
#if !defined(BARRI_DATE)
#  warning "no barri date defined"
#  define BARRI_DATE "unknown"
#endif
#if !defined(BARRI_YEAR)
#  warning "no barri year defined"
#  define BARRI_YEAR "unknown"
#endif

extern "C" {
const std::string_view barri_year{AS_STR(BARRI_YEAR)};
const std::string_view barri_date{AS_STR(BARRI_DATE)};
const std::string_view barri_version{AS_STR(BARRI_VERSION)};
}
