# Basic Usage

Usage of `Zend\Json` involves using the two public static methods available:
`Zend\Json\Json::encode()` and `Zend\Json\Json::decode()`.

```php
// Retrieve a value:
$phpNative = Zend\Json\Json::decode($encodedValue);

// Encode it to return to the client:
$json = Zend\Json\Json::encode($phpNative);
```

## Pretty-printing JSON

Sometimes, it may be hard to explore *JSON* data generated by `Zend\Json\Json::encode()`, since it
has no spacing or indentation. In order to make it easier, `Zend\Json\Json` allows you to
pretty-print *JSON* data in the human-readable format with `Zend\Json\Json::prettyPrint()`.

```php
// Encode it to return to the client:
$json = Zend\Json\Json::encode($phpNative);
if ($debug) {
    echo Zend\Json\Json::prettyPrint($json, array("indent" => " "));
}
```

Second optional argument of `Zend\Json\Json::prettyPrint()` is an option array. Option `indent`
allows to set indentation string - by default it's a single tab character.
